﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Pages;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;
using System.Web.Security;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.Utilities;
using System.Windows.Threading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for AddCustomerInfo.xaml
    /// </summary>
    public partial class AddPayment : Window
    {
        static string EnteredAmount { get; set; }

        public AddPayment()
        {
            InitializeComponent();
            EnteredAmount = string.Empty;
            LoadCurrentOrderTotal();
            txtAmountPaid.Focus();

        }

        private void LoadCurrentOrderTotal()
        {
            decimal paid = 0, due = 0, balance = 0, balanceCust = 0;

            paid = AppSession.CurrentOrders.PaidAmount;
            balance = (paid - AppSession.CurrentOrders.Total);
            balance = balance > 0 ? balance : 0;

            balanceCust = AppSession.CurrentOrders.Total - paid;
            balanceCust = balanceCust > 0 ? balanceCust : 0;

            lblBalance.Text = balance.ToString("Change: $ 0.00");

            due = (AppSession.CurrentOrders.Total - AppSession.CurrentOrders.PaidAmount) > 0 ? AppSession.CurrentOrders.Total - AppSession.CurrentOrders.PaidAmount : 0;

            txtAmountPaid.TextChanged -= txtAmountPaid_TextChanged;
            txtAmountPaid.Text = due > 0 ? due.ToString("0.00") : string.Empty;
            txtAmountPaid.TextChanged += txtAmountPaid_TextChanged;
            txtAmountPaid.CaretIndex = txtAmountPaid.Text.Length;
            txtAmountPaid.Select(0, txtAmountPaid.Text.Length);

            lblTotalAmount.Text = due.ToString("$ 0.00");

            gvOrderPayments.ItemsSource = null;
            gvOrderPayments.ItemsSource = AppSession.CurrentOrders.OrdersPaymentList;
            rbCash.IsChecked = true;
        }

        private void btnConfirmPayment_Click(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentOrders.OrdersPaymentList.Count <= 0)
            {
                App.ShowErrorMessageBox("Please add any Payment", "Ei8ht POS");
                //cbPaymentMethod.Focus();
                return;
            }
            if (AppSession.CurrentOrders.PaidAmount < AppSession.CurrentOrders.Total)
            {
                App.ShowErrorMessageBox("Paid Amount is lesser than the bill amount", "Ei8ht POS");
                return;
            }

            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                Action action = () =>
                {
                    if (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total)
                    {
                        AppSession.CurrentOrders.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;
                        AppSession.CurrentOrders.IsShipToBillingAddress = true;
                        AppSession.CurrentOrders.OrderFrom = AppSession.OrderFrom;
                        AppSession.CurrentOrders.OrderStatus = "Delivered";

                        int days = AppSession.CurrentOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                        AppSession.CurrentOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                        OrdersPayment lastPayment = AppSession.CurrentOrders.OrdersPaymentList.Last<OrdersPayment>();
                        if (lastPayment != null)
                        {
                            AppSession.CurrentOrders.PaymentMethod = lastPayment.PaymentMethod;
                            AppSession.CurrentOrders.PaymentType = lastPayment.PaymentType;
                            AppSession.CurrentOrders.TransactionReference = lastPayment.TransactionReference;
                            AppSession.CurrentOrders.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                        }

                        if (OrdersBL.Save(AppSession.CurrentOrders))
                        {
                            PoleDisplayHelper.DisplayItem("Change", " ", string.Format("{0:C}", (AppSession.CurrentOrders.PaidAmount - AppSession.CurrentOrders.Total)));
                            //OrdersBL.GenerateInvoice(AppSession.CurrentOrders.UniqueID);
                            //AppSession.CurrentOrders = OrdersBL.GetItem(AppSession.CurrentOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                            AppSession.UpdateOrderProductQty(AppSession.CurrentOrders);
                            //For Cash Transactions alone
                            List<OrdersPayment> CurrentPayment = AppSession.CurrentOrders.OrdersPaymentList;
                            if (CurrentPayment.Where(a => a.PaymentMethod.ToLower().Equals("cash")).Any())
                                AppSession.OpenCashDrawer();
                        }
                    }
                };
                Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
            });

            if (!result.OperationFailed)
            {
                this.Tag = true;
                this.Close();
            }
            else
                App.ShowMessageBox(result.Error.Message, "Ei8ht POS");
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            LoadCurrentOrderTotal();
        }

        private void btnCancelPayment_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void btnAddPayment_Click(object sender, RoutedEventArgs e)
        {
            if (ValidatePayments())
            {
                if (GetPayment() != null && GetPayment().Trim().ToLower().Equals("card"))
                {
                    if (Convert.ToBoolean(AppSession.OCBCConnected))
                    {
                        #region For Card Payment Type
                        OCBC.OCBCTerminal ocbcpay = new OCBC.OCBCTerminal(decimal.Parse(txtAmountPaid.Text.Trim()));
                        ocbcpay.Owner = this;
                        ocbcpay.ShowInTaskbar = false;
                        ocbcpay.ShowDialog();
                        if (bool.Parse(ocbcpay.Tag.ToString()))
                        {
                            if (AppSession.CurrentOCBCTransaaction != null)
                            {
                                ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                                {
                                    Action action = () =>
                                    {
                                        decimal paid = 0;

                                        OrdersPayment ordPayment = new OrdersPayment();
                                        ordPayment.UniqueID = Guid.NewGuid();
                                        ordPayment.IsActive = true;

                                        ordPayment.OCBCResponse = AppSession.CurrentOCBCTransaaction;

                                        if (ordPayment.OCBCResponse.ResponseType == OCBCHelper.TransactionType.Success && ordPayment.OCBCResponse.ResponseCode.Equals("00"))
                                        {
                                            paid = ordPayment.PaidAmount = AppSession.CurrentOCBCTransaaction.NetAmount;
                                            ordPayment.TransactionReference = AppSession.CurrentOCBCTransaaction.ECRReferenceNo;
                                        }

                                        ordPayment.PaymentMethod = GetPayment();
                                        ordPayment.PaymentType = string.Empty;
                                        ordPayment.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;

                                        AppSession.CurrentOCBCTransaaction = null; //Initialize for next transaction

                                        AppSession.CurrentOrders.PaidAmount += paid;
                                        ordPayment.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                                        AppSession.CurrentOrders.OrdersPaymentList.Add(ordPayment);

                                        ClearControls();
                                        LoadCurrentOrderTotal();
                                    };
                                    Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                                });
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        #region Manual Payment
                        decimal paid = 0;

                        OrdersPayment ordPayment = new OrdersPayment();
                        ordPayment.UniqueID = Guid.NewGuid();
                        ordPayment.IsActive = true;

                        OCBCHelper.OCBCTransactionResponse response = new OCBCHelper.OCBCTransactionResponse()
                        {
                            UniqueID = Guid.NewGuid(),
                            IsActive = true,
                            AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID,
                            DeviceRequest = "Manual Request",
                            DeviceResponse = string.Empty,
                            NetAmount = decimal.Parse(txtAmountPaid.Text),
                            ECRReferenceNo = txtReferenceNo.Text.Trim(),
                            ResponseType = OCBCHelper.TransactionType.Success,
                            ResponseCode = "00"
                        };
                        AppSession.CurrentOCBCTransaaction = response;

                        ordPayment.OCBCResponse = AppSession.CurrentOCBCTransaaction;

                        if (ordPayment.OCBCResponse.ResponseType == OCBCHelper.TransactionType.Success && ordPayment.OCBCResponse.ResponseCode.Equals("00"))
                        {
                            paid = ordPayment.PaidAmount = AppSession.CurrentOCBCTransaaction.NetAmount;
                            ordPayment.TransactionReference = AppSession.CurrentOCBCTransaaction.ECRReferenceNo;
                        }

                        ordPayment.PaymentMethod = GetPayment();
                        ordPayment.PaymentType = string.Empty;
                        ordPayment.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;

                        AppSession.CurrentOCBCTransaaction = null; //Initialize for next transaction

                        AppSession.CurrentOrders.PaidAmount += paid;
                        ordPayment.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                        AppSession.CurrentOrders.OrdersPaymentList.Add(ordPayment);

                        ClearControls();
                        LoadCurrentOrderTotal();
                        #endregion
                    }
                }
                else if (GetPayment() != null && GetPayment().Trim().ToLower().Equals("nets"))
                {
                    if (Convert.ToBoolean(AppSession.NETSConnected))
                    {
                        #region For NETS Payment
                        NETS.NETSTerminal netsPayment = new NETS.NETSTerminal(decimal.Parse(txtAmountPaid.Text.Trim()));
                        netsPayment.Owner = this;
                        netsPayment.ShowInTaskbar = false;
                        netsPayment.ShowDialog();
                        if (bool.Parse(netsPayment.Tag.ToString()))
                        {
                            if (AppSession.CurrentNETSTransaction != null)
                            {
                                ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                                {
                                    Action action = () =>
                                    {
                                        decimal paid = 0;

                                        OrdersPayment ordPayment = new OrdersPayment();
                                        ordPayment.UniqueID = Guid.NewGuid();
                                        ordPayment.IsActive = true;

                                        ordPayment.NETSResponse = AppSession.CurrentNETSTransaction;

                                        if (ordPayment.NETSResponse.IsApproved)
                                        {
                                            if (ordPayment.NETSResponse.ResponseType == NETSHelper.TransactionType.ContactLess)
                                                paid = ordPayment.PaidAmount = AppSession.CurrentNETSTransaction.TDTransactionAmount;
                                            else
                                                paid = ordPayment.PaidAmount = AppSession.CurrentNETSTransaction.TransactionAmount;
                                            ordPayment.TransactionReference = AppSession.CurrentNETSTransaction.BatchNumber;
                                        }

                                        ordPayment.PaymentMethod = GetPayment();
                                        ordPayment.PaymentType = string.Empty;
                                        ordPayment.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;

                                        AppSession.CurrentNETSTransaction = null; //Initialize for next transaction

                                        AppSession.CurrentOrders.PaidAmount += paid;
                                        ordPayment.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                                        //AppSession.CurrentOrders.OrdersPaymentList = AppSession.CurrentOrders.OrdersPaymentList != null ? AppSession.CurrentOrders.OrdersPaymentList : new List<OrdersPayment>();
                                        AppSession.CurrentOrders.OrdersPaymentList.Add(ordPayment);

                                        ClearControls();
                                        LoadCurrentOrderTotal();
                                    };
                                    Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                                });
                            }
                        }
                        #endregion
                    }
                    else
                    {
                        #region Manual Payment if no device found
                        decimal paid = 0;

                        OrdersPayment ordPayment = new OrdersPayment();
                        ordPayment.UniqueID = Guid.NewGuid();
                        ordPayment.IsActive = true;

                        NETSHelper.TransactionResponse response = new NETSHelper.TransactionResponse()
                        {
                            UniqueID = Guid.NewGuid(),
                            IsActive = true,
                            AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID,
                            DeviceRequest = "Manual Request",
                            DeviceResponse = string.Empty,
                            IsApproved = true,
                            TDTransactionAmount = decimal.Parse(txtAmountPaid.Text),
                            ResponseType = NETSHelper.TransactionType.ContactLess,
                            BatchNumber = txtReferenceNo.Text.Trim()
                        };
                        AppSession.CurrentNETSTransaction = response;

                        ordPayment.NETSResponse = AppSession.CurrentNETSTransaction;

                        if (ordPayment.NETSResponse.IsApproved)
                        {
                            if (ordPayment.NETSResponse.ResponseType == NETSHelper.TransactionType.ContactLess)
                                paid = ordPayment.PaidAmount = AppSession.CurrentNETSTransaction.TDTransactionAmount;
                            else
                                paid = ordPayment.PaidAmount = AppSession.CurrentNETSTransaction.TransactionAmount;
                            ordPayment.TransactionReference = AppSession.CurrentNETSTransaction.BatchNumber;
                        }

                        ordPayment.PaymentMethod = GetPayment();
                        ordPayment.PaymentType = string.Empty;
                        ordPayment.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;

                        AppSession.CurrentNETSTransaction = null; //Initialize for next transaction

                        AppSession.CurrentOrders.PaidAmount += paid;
                        ordPayment.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                        AppSession.CurrentOrders.OrdersPaymentList.Add(ordPayment);

                        ClearControls();
                        LoadCurrentOrderTotal();
                        #endregion
                    }
                }
                else
                {
                    #region Other Payment Type
                    ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                    {
                        Action action = () =>
                        {
                            decimal paid = decimal.Parse(txtAmountPaid.Text.Trim());

                            OrdersPayment ordPayment = new OrdersPayment();
                            ordPayment.UniqueID = Guid.NewGuid();
                            ordPayment.IsActive = true;

                            ordPayment.PaidAmount = paid;
                            ordPayment.PaymentMethod = GetPayment(); //cbPaymentMethod.SelectedValue.ToString();
                            ordPayment.PaymentType = string.Empty;
                            ordPayment.TransactionReference = txtReferenceNo.Text.Trim();
                            ordPayment.AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID;

                            AppSession.CurrentOrders.PaidAmount += paid;
                            ordPayment.PaymentStatus = (AppSession.CurrentOrders.PaidAmount >= AppSession.CurrentOrders.Total) ? "Completed" : "Pending";
                            //AppSession.CurrentOrders.OrdersPaymentList = AppSession.CurrentOrders.OrdersPaymentList != null ? AppSession.CurrentOrders.OrdersPaymentList : new List<OrdersPayment>();
                            AppSession.CurrentOrders.OrdersPaymentList.Add(ordPayment);

                            ClearControls();
                            LoadCurrentOrderTotal();
                            //cbPaymentMethod.Focus();
                            //cbPaymentType.IsDropDownOpen = true;
                            //txtAmountPaid.CaretIndex = txtAmountPaid.Text.Length;
                            //txtAmountPaid.Select(0, txtAmountPaid.Text.Length);

                        };
                        Dispatcher.BeginInvoke(DispatcherPriority.Send, action);
                    });
                    #endregion
                }
            }
        }

        private void ClearControls()
        {
            rbCash.IsChecked = true;
            txtAmountPaid.Clear();
            txtReferenceNo.Clear();
            //cbPaymentMethod.Focus();
        }

        private bool ValidatePayments()
        {

            if ((AppSession.CurrentOrders.Total - AppSession.CurrentOrders.PaidAmount) <= 0)
            {
                App.ShowErrorMessageBox("Already paid the full amount", "Ei8ht POS");
                return false;
            }

            if (GetPayment() == null)
            {
                App.ShowErrorMessageBox("Please Select Payment Type", "Ei8ht POS");
            }

            //if (cbPaymentMethod.SelectedValue == null || cbPaymentMethod.SelectedValue.ToString() == "Please Select")
            //{
            //    App.ShowErrorMessageBox("Please select valid Payment Method", "Ei8ht POS");
            //    cbPaymentMethod.Focus();
            //    return false;
            //}

            //if (cbPaymentType.SelectedValue == null || cbPaymentType.SelectedValue == "Please Select")
            //{
            //    App.ShowErrorMessageBox("Please select valid Payment Type", "Ei8ht POS");
            //    cbPaymentType.Focus();
            //    return false;
            //}

            if (!ValidationUtility.ValidateDecimal(txtAmountPaid.Text.Trim()))
            {
                App.ShowErrorMessageBox("Please enter valid Amount", "Ei8ht POS");
                txtAmountPaid.Focus();
                return false;
            }

            return true;
        }

        private string GetPayment()
        {
            if (rbCash.IsChecked.Value)
            {
                return "cash";
            }
            else if (rbCard.IsChecked.Value)
            {
                return "card";
            }
            else if (rbNets.IsChecked.Value)
            {
                return "nets";
            }
            //else if (rbOthers.IsChecked.Value)
            //{
            //    return "others";
            //}
            else
                return null;
        }

        private void btnRemove_Click(object sender, RoutedEventArgs e)
        {
            //Set the Current User Unique ID from sender.Tag value and store it in Some Appsession Variable and use it while checking out.
            Button btnRemove = sender as Button;
            Guid ordersPaymentID = Guid.Parse(btnRemove.Tag.ToString());
            RemovePayment(ordersPaymentID);
        }

        private void RemovePayment(Guid ordersPaymentID)
        {
            //orderspay AppSession
            OrdersPayment curPay = AppSession.CurrentOrders.OrdersPaymentList.Where(x => x.UniqueID == ordersPaymentID).FirstOrDefault<OrdersPayment>();

            if (curPay != null)
            {
                AppSession.CurrentOrders.PaidAmount -= curPay.PaidAmount;
                AppSession.CurrentOrders.OrdersPaymentList.Remove(curPay);
                LoadCurrentOrderTotal();
            }
        }

        private void txtAmountPaid_TextChanged(object sender, TextChangedEventArgs e)
        {
            string NewAmount = string.Empty;
            try
            {
                txtAmountPaid.TextChanged -= txtAmountPaid_TextChanged;
                EnteredAmount = txtAmountPaid.Text.Trim().Replace(".", string.Empty);

                if (EnteredAmount.Length > 2)
                {
                    string DecimalValue, WholeValue;
                    DecimalValue = EnteredAmount.Substring(EnteredAmount.Length - 2, 2);
                    WholeValue = EnteredAmount.Substring(0, EnteredAmount.Length - 2);
                    NewAmount = string.Format("{0}.{1}", WholeValue, DecimalValue);
                }
                else
                {
                    NewAmount = string.Format(".{0}", EnteredAmount);
                }
                txtAmountPaid.TextChanged -= txtAmountPaid_TextChanged;
                txtAmountPaid.Text = NewAmount;
                txtAmountPaid.TextChanged += txtAmountPaid_TextChanged;
                txtAmountPaid.CaretIndex = txtAmountPaid.Text.Length;
            }
            catch
            {

            }
        }

        private void txtAmountPaid_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                btnAddPayment.Focus();
            }
            else if (e.Key == Key.Delete || e.Key == Key.Back || e.Key == Key.End || e.Key == Key.Home ||
                (e.Key >= Key.NumPad0 && e.Key <= Key.NumPad9) || (e.Key >= Key.D0 && e.Key <= Key.D9))
            {
                e.Handled = false;
            }
            else
                e.Handled = true;
        }

        private void cbPaymentMethod_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                //cbPaymentType.Focus();
                //cbPaymentType.IsDropDownOpen = true;
            }
        }

        private void cbPaymentType_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                txtReferenceNo.Focus();
            }
        }

        private void txtReferenceNo_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                txtAmountPaid.Focus();
            }
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            rbCash.IsChecked = true;
        }

        private void Button_Click_2(object sender, RoutedEventArgs e)
        {
            rbCard.IsChecked = true;
        }

        private void Button_Click_3(object sender, RoutedEventArgs e)
        {
            rbNets.IsChecked = true;
        }

        //private void Button_Click_4(object sender, RoutedEventArgs e)
        //{
        //    rbOthers.IsChecked = true;
        //}
    }
}
